﻿using IpPbx.Samples.Shared;
using SWConfigDataClientLib.Proxies.Admin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;

namespace IpPbx.EditUserData
{
    public partial class frmMain : Form
    {
        #region Fields & CTor

        private CDSLib _cdsLib;
        private UserAdminView1EntrySortableCollection _userView;

        public frmMain()
        {
            InitializeComponent();
        }

        #endregion

        #region UI Interaction

        private void btnLogin_Click(object sender, EventArgs e)
        {
            _cdsLib = new CDSLib(txtName.Text,
                                     txtPassword.Text,
                                     txtServer.Text);

            if (!_cdsLib.TestConnection())
            {
                MessageBox.Show("Connection failed", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (!LoadUsers())
            {
                return;
            }

            txtName.Enabled = false;
            txtPassword.Enabled = false;
            txtServer.Enabled = false;
            btnLogin.Enabled = false;
            btnRefresh.Enabled = true;
            cbxAllUsers.Checked = false;
            cbxAllUsers.Enabled = true;
            cbxAlwaysOnTop.Checked = false;
            cbxAlwaysOnTop.Enabled = true;
            cbxPopupOnIncomingCalls.Checked = false;
            cbxPopupOnIncomingCalls.Enabled = true;
        }

        //------------------------------------------------------------------------------------

        private void btnRefresh_Click(object sender, EventArgs e)
        {
            LoadUsers();
        }

        //------------------------------------------------------------------------------------        

        private void cbxAllUsers_CheckedChanged(object sender, EventArgs e)
        {
            for (var x = 0; x < lbxUsers.Items.Count; x++)
            {
                lbxUsers.SetSelected(x, cbxAllUsers.Checked);
            }
        }

        //------------------------------------------------------------------------------------

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            try
            {
                // Is any user selected?
                var selectedUsers = lbxUsers.SelectedItems;
                if (selectedUsers == null ||
                    selectedUsers.Count == 0)
                {
                    throw new ArgumentException("No user selected");
                }

                // Validation of selected users
                var userIdList = new List<int>();
                foreach (var user in selectedUsers)
                {
                    var userEntry = _userView.FirstOrDefault(x => x.Name == user.ToString());
                    if (userEntry == null)
                    {
                        continue;
                    }

                    userIdList.Add(userEntry.UserID);
                }

                // Do you we have at least one valid user?
                if (userIdList.Count == 0)
                {
                    throw new ArgumentException("No valid user selected");
                }

                // Let do the work ;-)
                _cdsLib.UpdateUserData(userIdList, cbxAlwaysOnTop.Checked, cbxPopupOnIncomingCalls.Checked);

                MessageBox.Show("User(s) updated successfully.", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        #endregion UI Interaction

        #region Private Methods

        private bool LoadUsers()
        {
            try
            {
                lbxUsers.Items.Clear();

                _userView = _cdsLib.GetUserView(true);

                foreach (var entry in _userView)
                {
                    // Filter builtin user (like Conference & MEM)
                    if (!entry.IsShortnameNull)
                        continue;

                    lbxUsers.Items.Add(entry.Name);
                }

                lbxUsers.Enabled = true;
                cbxAllUsers.Enabled = true;
                btnUpdate.Enabled = true;

                return true;
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            return false;
        }

        #endregion
    }
}
