﻿using IpPbx.Samples.Shared;
using SWConfigDataClientLib.Proxies.Files;
using System;
using System.IO;
using System.Windows.Forms;

namespace IpPbx.FileDemo
{
    public partial class frmMain : Form
    {
        private CDSLib _cdsLib;
        private FileListEntrySortableCollection _skinList;

        //------------------------------------------------------------------------------------

        public frmMain()
        {
            InitializeComponent();
        }

        //------------------------------------------------------------------------------------

        private void cmdLogin_Click(object sender, EventArgs e)
        {
            _cdsLib = new CDSLib(txtName.Text,
                                      txtPassword.Text,
                                      txtServer.Text);

            if (_cdsLib.TestConnection())
            {
                txtName.Enabled = false;
                txtPassword.Enabled = false;
                txtServer.Enabled = false;
                cmdLogin.Enabled = false;
                cmdLoadSkins.Enabled = true;
                cbxSkinList.Enabled = true;
            }
            else
            {
                MessageBox.Show("Connection failed", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //------------------------------------------------------------------------------------

        private void cmdLoadSkins_Click(object sender, EventArgs e)
        {
            try
            {
                cbxSkinList.Items.Clear();

                _skinList = _cdsLib.GetSkins();

                // Add skins to combobox
                foreach (var entry in _skinList)
                {
                    cbxSkinList.Items.Add(entry.Name);
                }

                // Select first skin in the combobox
                if (cbxSkinList.Items.Count > 0)
                {
                    cbxSkinList.SelectedIndex = 0;
                }

                cmdLoadSkins.Enabled = false;
                cmdDownloadSkin.Enabled = true;
                cmdUploadSkin.Enabled = true;
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //------------------------------------------------------------------------------------

        private void cmdDownloadSkin_Click(object sender, EventArgs e)
        {
            try
            {
                var dialog = new SaveFileDialog
                {
                    FileName = cbxSkinList.Text,
                    Filter = @"Skin files|*.cab|All files|*.*"
                };

                var res = dialog.ShowDialog();
                if (res == DialogResult.OK)
                {
                    var fileEntry = _skinList[cbxSkinList.SelectedIndex];
                    var localTempFilePath = _cdsLib.GetFile(fileEntry);
                    File.Copy(localTempFilePath, dialog.FileName);
                    File.SetAttributes(dialog.FileName, FileAttributes.Normal);
                }
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //------------------------------------------------------------------------------------

        private void cmdUploadSkin_Click(object sender, EventArgs e)
        {
            try
            {
                var dialog = new OpenFileDialog { Filter = @"Skin files|*.cab|All files|*.*" };
                var res = dialog.ShowDialog();
                if (res == DialogResult.OK)
                {
                    _cdsLib.AddSkin(dialog.SafeFileName, dialog.FileName);
                    cmdLoadSkins_Click(null, null);
                }
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //------------------------------------------------------------------------------------        
    }
}
